<?php get_header(); ?>
<div id="author">
	<?php
	$authorID = get_query_var('author');
	$authorName = get_the_author_meta( 'display_name', $authorID );
	$authorMail = get_the_author_meta( 'user_email', $authorID );
	$authorBio = get_the_author_meta( 'user_description', $authorID );
	$authorFacebook = get_the_author_meta( 'facebook', $authorID );
	$authorTwitter = get_the_author_meta( 'twitter', $authorID );
	$authorInstagram = get_the_author_meta( 'instagram', $authorID );
	$authorLinkedin = get_the_author_meta( 'linkedin', $authorID );
	$image = safir_get_author_image($authorID, 150);
	?>

	<div class="safirBox">
		<div class="pageHeading">
			<h1 class="title"><?php echo $authorName ?></h1>
		</div>

		<div class="authorBox">
			<div class="thumb">
				<div class="image">
					<a href="<?php echo get_author_posts_url($authorID) ?>"><img src="<?php echo $image; ?>" width="140" height="140" alt="<?php echo $authorName ?>" /></a>
				</div>
			</div>
			<div class="detail">
				<div class="bio">
					<?php echo $authorBio ?>
				</div>
				<div class="share safirSocial">
					<ul>
						<?php if($authorFacebook) : ?>
							<li class="facebook">
								<a rel="external" href="<?php echo $authorFacebook ?>"></a>
							</li>
						<?php endif; ?>
						<?php if($authorTwitter) : ?>
							<li class="twitter">
								<a rel="external" href="<?php echo $authorTwitter ?>"></a>
							</li>
						<?php endif; ?>
						<?php if($authorInstagram) : ?>
							<li class="instagram">
								<a rel="external" href="<?php echo $authorInstagram ?>"></a>
							</li>
						<?php endif; ?>
						<?php if($authorLinkedin) : ?>
							<li class="linkedin">
								<a rel="external" href="<?php echo $authorLinkedin ?>"></a>
							</li>
						<?php endif; ?>
					</ul>
				</div>
			</div>
		</div>
	</div>

	<div class="mainHeading stick margintop">
		<div class="safiricon icon icon61"></div>
		<div class="title"><?php _e("YAZARIN EKLEMİŞ OLDUĞU YAZILAR", "lara") ; ?></div>
	</div>
	<div class="safirBox">
		<div id="authorRelated">
			<?php while (have_posts()) : the_post(); ?>
				<div class="item">
					<div class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
					<div class="meta"><?php the_time('j F Y'); ?></div>
				</div>
			<?php endwhile; ?>
		</div>
		<?php safirnavi(); ?>

	</div>

</div>
<?php get_sidebar('article'); ?>
<?php get_footer(); ?>
