<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta name="viewport" content="initial-scale=1" />
<meta charset="<?php bloginfo('charset'); ?>" />
<?php if(is_single()) wp_enqueue_script('comment-reply'); ?>
<!--[if lt IE 9]><script src="<?php bloginfo('template_url')?>/scripts/html5shiv.js"></script><![endif]-->
<link rel="shortcut icon" href="<?php echo xoption('favicon') ?>" type="image/png">
<?php
wp_head();
echo xoption('headerScript');
echo xoption('gaScript');
include("lib/safirtema/style.php");
?>
</head>
<?php
if(wp_is_mobile()) :
	$class = 'mobile';
else :
	$class = 'desktop';
endif;
if(xoption("fitImage")) $class .= " fitImage";
if(xoption("stickySidebar")) $class .= " stickySidebar";
if(wp_is_mobile() && xoption('hideMobileSidebar') ) $class .= " mobileNoSidebar";
?>
<body <?php body_class($class) ?>>

<div id="safirPage">

<?php
if(!wp_is_mobile() && xoption('userColor') == "evet") :
	?>
	<div id="switcher">
		<form action="<?php bloginfo('url'); ?>" method="get">
			<p>Site Rengi</p>
			<input class="switcherInput input1" autocomplete="off" name="larac1" type="text" value="<?php echo $larac1; ?>" size="7" maxlength="7" style="width: 88px;border:1px solid #dedede;font-size:12px;height: 28px;">
			<input class="switcherInput input2" autocomplete="off" name="larac2" type="text" value="<?php echo $larac2; ?>" size="7" maxlength="7" style="width: 88px;border:1px solid #dedede;font-size:12px;height: 28px;">
			<div class="designButtons">
				<a href="<?php echo get_home_url() ?>?cat=1&listing=style1">Liste 1</a>
				<a href="<?php echo get_home_url() ?>?cat=1&listing=style2">Liste 2</a>
			</div>
			<input type="submit" value="Siteye Uygula" style="text-transform: capitalize; padding: 0; width: 88px;margin-top:4px;font-size:12px;height: 28px;" />
		</form>
		<div class="icon"><span></span></div>
	</div>
<?php endif; ?>

<header>
	<div id="topbar">
		<div class="innerContainer" style="overflow: visible">
			<?php safir_nav_menu('topmenu'); ?>
			<div class="rightGroup">
				<?php include('parts/social.php'); ?>
				<?php include('parts/search.php'); ?>
				<?php if(xoption("showLoginButton")) : ?>
					<div id="membership">
						<div class="membershipButton">
							<?php if(is_user_logged_in()) : ?>
								<?php
								$current_user = wp_get_current_user();
								$authorID = $current_user->ID;
								$authorName = get_the_author_meta( 'first_name', $authorID ) . ' ' . get_the_author_meta( 'last_name', $authorID );
								if($authorName == " ") {
									$authorName = get_the_author_meta( 'display_name', $authorID );
								}
								?>
								<a href="<?php echo get_permalink(xoption('profilePage')) ?>"><?php _e("Hoşgeldiniz", "lara") ?>, <?php echo $authorName ?></a>
							<?php else : ?>
								<a href="<?php echo get_permalink(xoption('membershipPage')) ?>"><?php _e("Üyelik", "lara") ?></a>
							<?php endif; ?>
						</div>
						<?php if(is_user_logged_in()) : ?>
							<div id="loginMenu">
								<div class="items">
									<?php if(xoption('profilePage') != "-1") : ?>
										<div class="item">
											<a class="profile" href="<?php echo get_permalink(xoption('profilePage')) ?>">
											<?php echo get_the_title(xoption('profilePage')); ?>
											</a>
										</div>
									<?php endif; ?>
									<?php if(xoption('postsPage') != "-1") : ?>
										<div class="item">
											<a class="posts" href="<?php echo get_permalink(xoption('postsPage')) ?>">
											<?php echo get_the_title(xoption('postsPage')); ?>
											</a>
										</div>
									<?php endif; ?>
									<?php if(xoption('addPostsPage') != "-1") : ?>
										<div class="item">
											<a class="add" href="<?php echo get_permalink(xoption('addPostsPage')) ?>">
											<?php echo get_the_title(xoption('addPostsPage')); ?>
											</a>
										</div>
									<?php endif; ?>
									<div class="item">
										<a class="user" href="<?php echo get_author_posts_url($current_user->ID) ?>">
											<?php _e("Yazar Sayfam", "lara"); ?>
										</a>
									</div>
									<div class="item">
										<a class="logout" href="<?php echo wp_logout_url(get_bloginfo('url')) ?>">
										<?php _e("Çıkış Yap", "lara"); ?>
										</a>
									</div>
								</div>
							</div>
						<?php endif; ?>
					</div>
				<?php endif; ?>
			</div>
			<div style="clear: both;"></div>
		</div>

	</div>
	<div id="header-cont">
		<div class="innerContainer">
			<div id="mobileHeader">
				<div class="toggleMenu mobileButton"></div>
				<div id="header-logo">
					<?php if(is_home()) : $tag = "h1"; else : $tag = "span"; endif;?>
					<?php echo "<$tag>"; ?>
					<?php if(is_home()) echo '<span style="display:none">'.get_bloginfo("name").'</span>'; ?>
					<a href="<?php bloginfo('url'); ?>">
						<img src="<?php echo xoption('logo'); ?>" alt="<?php bloginfo('name'); ?>" title="<?php bloginfo("name"); ?> - <?php _e("Anasayfa", "lara") ?>" width="<?php echo xoption('logoWidth'); ?>" height="<?php echo xoption('logoHeight'); ?>" style="height:<?php echo xoption('logoHeight'); ?>px;" />
					</a>
					<?php echo "</$tag>"; ?>
				</div>
				<?php if(xoption("showMobileSearch")) : ?>
					<div class="searchButton mobileButton"></div>
					<div class="searchform">
						<form method="get" action="<?php bloginfo('url'); ?>">
							<input type="text" name="s" value="<?php _e("Arama yap...", "lara") ?>" onblur="if(this.value=='') this.value=this.defaultValue;" onfocus="if(this.value==this.defaultValue) this.value='';" />
							<button type="submit"></button>
							<span class="close"></span>
						</form>
					</div>
				<?php endif; ?>
			</div>
			<div id="menuGroup">
				<div id="mainMenu">
					<nav id="menu">
						<?php safir_nav_menu('mainmenu'); ?>
					</nav>
				</div>
			</div>
			<div style="clear: both"></div>
		</div>
	</div>
</header>

<div id="overlay"></div>

<?php if(xoption("showMobileMenuButton")) : ?>
	<div class="hamburgerMenuButton"></div>
<?php endif; ?>

<div id="hamburgermenu">
	<div class="logoBlock">
		<a href="<?php bloginfo('url'); ?>">
			<img src="<?php echo xoption('logo'); ?>" alt="<?php bloginfo('name'); ?>" title="<?php bloginfo('name'); ?> - <?php _e("Anasayfa", "lara") ?>" width="<?php echo xoption('logoWidth'); ?>" height="<?php echo xoption('logoHeight'); ?>" style="height:<?php echo xoption('logoHeight'); ?>px;" />
		</a>
		<span class="close"></span>
	</div>

	<?php if(xoption("showLoginButton")) : ?>
		<div class="membership">
			<?php if(is_user_logged_in()) : ?>
				<?php
				$current_user = wp_get_current_user();
				$authorID = $current_user->ID;
				$authorName = get_the_author_meta( 'first_name', $authorID ) . ' ' . get_the_author_meta( 'last_name', $authorID );
				if($authorName == " ") {
					$authorName = get_the_author_meta( 'display_name', $authorID );
				}
				?>
				<a class="text" href="<?php echo get_permalink(xoption('profilePage')) ?>"><?php _e("Hoşgeldiniz", "lara") ?>, <?php echo $authorName ?></a>
				<div class="membershipMenuButton"></div>
			<?php else : ?>
				<a class="text" href="<?php echo get_permalink(xoption('membershipPage')) ?>"><?php _e("Üyelik İşlemleri", "lara") ?></a>
			<?php endif; ?>
		</div>
	<?php endif; ?>

	<div id="mobilemenuContainer">
		<div id="mobilemenu">
			<?php safir_nav_menu('mobilemenu'); ?>
		</div>
	</div>

	<div id="mobileSocial">
		<?php include('parts/social.php'); ?>
	</div>

</div>

<?php if( (wp_is_mobile() && xoption('hideWideSidebar')) == false ) : $showWideSidebar = false; ?>
	<?php if(!is_home()) : ?>
		<?php
		$wideWidgetPosition = xoption('wideWidgetPosition');
		if(!is_array($wideWidgetPosition)) $wideWidgetPosition = array();
		if(
			(is_single() && !is_attachment() && in_array('post', $wideWidgetPosition)) ||
			(is_attachment() && in_array('gallery', $wideWidgetPosition)) ||
			(is_archive() && !is_author() && in_array('category', $wideWidgetPosition)) ||
			(is_page() && in_array('page', $wideWidgetPosition))
		) $showWideSidebar = true;

		if(
			(is_page_template("pages/page-authors.php") && !in_array('authors', $wideWidgetPosition)) ||
			(is_author() && !in_array('authors', $wideWidgetPosition)) ||
			(in_category(xoption("articleCategory")) && !in_array('authors', $wideWidgetPosition)) ||
			(is_category(xoption("articleCategory")) && !in_array('authors', $wideWidgetPosition)) ) $showWideSidebar = false;

		global $widgetPlace; $widgetPlace = "home";
		if(
			$showWideSidebar &&
			is_active_sidebar('sidebar-archive-ust') &&
			!is_404() &&
			!is_page_template("pages/page-membership.php") &&
			!is_page_template("profile/page-posts-edit.php") &&
			!is_page_template("profile/page-posts-add.php") &&
			!is_page_template("profile/page-posts.php") &&
			!is_page_template("profile/page-profile.php"))

			: ?>
			<div class="homeWidgetContainer wide">
				<div class="innerContainer">
					<?php
					$widgetPlace = "wide";
					dynamic_sidebar('sidebar-archive-ust');
					?>
				</div>
			</div>
		<?php endif; ?>
	<?php endif; ?>
<?php endif; ?>

<?php if(!is_home() && !is_404() && !is_attachment()) : ?>
	<div id="main">
		<div class="innerContainer">
			<div id="content">
<?php endif; ?>
