<?php
$args = array(
	'posts_per_page' => xoption('relatedCount'),
	'post_status' => 'publish',
	'no_found_rows' => true,
	'ignore_sticky_posts' => true,
	'post__not_in' => array(get_the_ID()),
);

switch(xoption('relatedTimeFilter')) {
	case 'all': break;
	case 'year':
		$args['year'] = date('Y');
	break;
	case 'month':
		$args['year'] = date('Y');
		$args['monthnum'] = date('n');
	break;
	case 'week':
		$args['year'] = date('Y');
		$args['w'] = date('W');
	break;
	case 'today':
		$args['year'] = date('Y');
		$args['monthnum'] = date('n');
		$args['day'] = date('j');
	break;
}

switch(xoption('relatedSortFilter')) {
	case "hit":
		if(function_exists('the_views')) {
			$field = 'views';
		} else {
			$field = 'hit';
		}
		$args['meta_key'] = $field;
		$args['orderby'] = 'meta_value_num';
		$args['order'] = 'DESC';
	break;
	case "rand": 
	case "date":
	case "comment_count":
		$args['orderby'] = xoption('relatedSortFilter');
	break;	
}

switch(xoption('relatedFilter')) {
	case "category":
		$catIDs = "";
		foreach(get_the_category() as $category) {
			if( $catIDs != "" ) { $catIDs .= ","; }
			$catIDs .= $category->cat_ID;
		}
		$args['cat'] = $catIDs;
	break;
	case "tag": 
		$tag_ids = array();
		$tags = wp_get_post_tags($post->ID);
		if ($tags) {
			foreach($tags as $tag) $tag_ids[] = $tag->term_id;
		}
		$args['tag__in'] = $tag_ids;
	break;	
}