<?php
/*
	Template Name: Tüm Yazarlar
*/
?>
<?php get_header(); ?>
<div id="allAuthorsPage" class="safirBox">
	<?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
		<div class="pageHeading">
			<h1 class="title"><?php the_title(); ?></h1>
			<?php if(xoption('breadcrumb')) : ?>
				<div id="breadcrumb">
					<?php sfrBreadcrumbs(); ?>
				</div>
			<?php endif; ?>
		</div>

	<div class="reading">
		<?php the_content(); ?>
	</div>
	<?php endwhile; ?>

	<div class="listing article">
		<div class="items">
			<?php $args = array(
				'blog_id'      => $GLOBALS['blog_id'],
				'role'         => 'author',
				'meta_key'     => '',
				'meta_value'   => '',
				'meta_compare' => '',
				'meta_query'   => array(),
				'include'      => array(),
				'exclude'      => array(),
				'orderby'      => 'login',
				'order'        => 'ASC',
				'offset'       => '',
				'search'       => '',
				'number'       => '',
				'count_total'  => false,
				'fields'       => 'all',
				'who'          => ''
			);
			$authors = get_users( $args );
			foreach ($authors as $author) {
				$image = safir_get_author_image($author->ID, 150);
				?>
				<div class="post-container">
					<div class="postarticle">
						<div class="thumb">
							<a href="<?php echo get_author_posts_url($author->ID) ?>">
								<img src="<?php echo $image ?>" width="75" height="75" alt="<?php echo $author->display_name ?>" />
							</a>
						</div>
						<div class="info">
							<p class="author-name"><a href="<?php echo get_author_posts_url($author->ID) ?>">
								<?php echo $author->display_name; ?></a>
							</p>
							<?php
							$query = new wp_query('posts_per_page=1&author='. $author->ID);
							if( $query->have_posts() ) {
								while ($query->have_posts()) {
									$query->the_post();
									?>
									<p class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></p>
									<p class="date"><?php the_time('d F Y'); ?></p>
								<?php
								}
							}
							?>
						</div>
					</div>
				</div>
				<?php
			}
			?>
		</div>
	</div>

</div>

<?php get_sidebar("article"); ?>
<?php get_footer(); ?>
