<?php
/*
	Template Name: Tema İkonları
*/
?>
<?php get_header(); ?>
<div class="safirBox">
	<?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
	<div id="iconsPage">
		<div class="pageHeading">
			<h1 class="title"><?php the_title(); ?></h1>
			<?php if(xoption('breadcrumb')) : ?>
				<div id="breadcrumb">
					<?php sfrBreadcrumbs(); ?>
				</div>
			<?php endif; ?>
		</div>
		<div class="reading">
			<?php the_content(); ?>
		</div>

		<div class="themeIcons">
			<?php
			global $safirIcons;
			$counter = 0;
			foreach($safirIcons as $key=>$code) {
				$counter++;
				?>
				<div class="item-container">
					<div class="item <?php echo $key; ?>">
						<span class="icon safiricon icon<?php echo $counter; ?>"></span>
						<div class="text">icon<?php echo $counter; ?></div>
					</div>
				</div>
			<?php } ?>
		</div>

		<style>

		.themeIcons {
			display: flex;
			flex-wrap: wrap;
			margin: 20px -20px -20px;
			overflow: hidden;
		}

		.themeIcons .item-container {
			width: 20%;
			padding: 20px;
			text-align: center;
		}

		.themeIcons .icon:before {
			float: none;
			font-size: 30px;
			height: 40px;
			line-height: 40px;
			margin-bottom: 10px;
			display: block;
		}

		.themeIcons .text {
		    line-height: 28px;
		    font-size: 12px;
		    border: 1px solid #d8e0e5;
		    border-radius: 5px;
		}

		<?php foreach($safirIcons as $key => $code) : ?>
		.themeIcons .item.<?php echo $key; ?> .icon:before {
			content:"<?php echo $code; ?>";
		}
		<?php endforeach; ?>

		@media all and (max-width:500px) {
			.themeIcons .item-container {
				width: 25%;
			}
		}

		@media all and (max-width:360px) {
			.themeIcons .item-container {
				width: 33.33333333%;
			}
		}

		</style>

	</div>
	<?php endwhile; ?>
</div>

<?php if(xoption("pageCommentsActive") && comments_open()) comments_template(); ?>

<?php get_sidebar('page'); ?>
<?php get_footer(); ?>
