<?php
/*
	Template Name: Üyelik
*/
?>
<?php
if(is_user_logged_in()) {
	wp_redirect(get_permalink(xoption('profilePage')));
	die();
}

if(isset($_POST['sfr_task']) && $_POST['sfr_task'] == 'login' ) {
	$result0 = array();
	$info['user_login'] = sanitize_text_field($_POST['sfr_username']);
	$info['user_password'] = sanitize_text_field($_POST['sfr_password']);
	$info['remember'] = sanitize_text_field($_POST['sfr_remember']);

	$user_signon = wp_signon( $info, false );
	if ( is_wp_error($user_signon) ){
		$result0 = array('class'=>'status warning', 'message'=>__('Kullanıcı adı veya şifreniz yanlış.', 'lara'));
	} else {
		wp_redirect(get_permalink(xoption("profilePage")));
		die();
	}
}

if(isset($_POST['sfr_task']) && $_POST['sfr_task'] == 'register' ) {
	$info = array();
	$info['name'] = sanitize_text_field($_POST['sfr_name']);
	$info['surname'] = sanitize_text_field($_POST['sfr_surname']);
	$info['username'] = sanitize_text_field($_POST['sfr_username']);
	$info['email'] = sanitize_text_field($_POST['sfr_email']);
	$info['password1'] = sanitize_text_field($_POST['sfr_password1']);
	$info['password2'] = sanitize_text_field($_POST['sfr_password2']);
	$info['captcha'] = sanitize_text_field($_POST['sfr_captcha']);
	$info['md5'] = sanitize_text_field($_POST['sfr_md5']);

	if(array_search("", $info) !== false) :
		$result1 = array('class'=>'status warning', 'message'=>__('Tüm alanları doldurmalısınız.', 'lara'));
	elseif($info['password1'] != $info['password2']) :
		$result1 = array('class'=>'status warning', 'message'=>__('Girdiğiniz şifreler uyuşmuyor.', 'lara'));
	elseif($info['md5'] != md5($info['captcha'])) :
		$result1 = array('class'=>'status warning', 'message'=>__('Güvenlik kodunu yanlış girdiniz.', 'lara'));
	else :
		if(filter_var($info['email'], FILTER_VALIDATE_EMAIL)) :
			$userdata = array(
				'user_login'  		=>  $info['username'],
				'first_name' 		=>  $info['name'],
				'last_name' 		=>  $info['surname'],
				'user_displayname' 	=>  $info['name'] . " " . $info['surname'],
				'user_email'   		=>  $info['email'],
				'user_pass'   		=>  $info['password1']
			);
			$wp_insert_user = wp_insert_user($userdata);
			if (is_wp_error($wp_insert_user)){
				$result1 = array('class'=>'status warning', 'message'=>$wp_insert_user->get_error_message());
			} else {
				$creds = array();
				$creds['user_login'] = $info['username'];
				$creds['user_password'] = $info['password1'];
				$creds['remember'] = true;
				$user = wp_signon( $creds, false );
				if ( is_wp_error($user) ) {
					$result1 = array('class'=>'status success', 'message'=>__('Üyeliğiniz oluşturuldu. Şimdi giriş yapabilirsiniz.', 'lara'));
				} else {
					wp_redirect(get_permalink(xoption("profilePage")));
				}
			}
		else:
			$result1 = array('class'=>'status warning', 'message'=>__('Mail adresiniz geçersiz.', 'lara'));
		endif;
	endif;
}

?>
<?php get_header(); ?>
<div id="profile" class="membershipPage">
	<div class="leftSide safirBox">
		<div class="pageHeading">
			<h2 class="title"><?php _e("Giriş Yap", "lara") ?></h2>
		</div>
		<div class="sfrIconForm" style="margin-bottom:40px;">
			<form method="post" name="sfrLoginForm">
			<?php
			if(!$result0) {
				$result0 = array('class' => 'status info', 'message' => __('Hesabınız varsa hemen giriş yapın.', 'lara'));
			}
			?>
			<p class="<?php echo $result0['class'] ?>" data-loading="<?php _e("Lütfen bekleyiniz", "lara") ?>..."><?php echo $result0['message'] ?></p>
			<div class="container">
				<div class="itemContainer">
					<div class="item name">
						<div class="icon"><span></span></div>
						<input placeholder="<?php _e("Kullanıcı adı veya mail adresi", "lara") ?>" type="text" name="sfr_username" value="<?php echo $info['user_login'] ?>" />
					</div>
				</div>
				<div class="itemContainer">
					<div class="item password">
						<div class="icon"><span></span></div>
						<input placeholder="<?php _e("Şifre", "lara") ?>" type="password" name="sfr_password" value="<?php echo $info['user_password'] ?>" />
					</div>
				</div>
			</div>
			<div class="container">
				<div class="itemContainer">
					<div class="safirCheckbox">
						<input type="checkbox" value="true"  id="sfr_remember" />
						<label for="sfr_remember"><span></span><?php _e("Beni Hatırla", "lara") ?></label>
					</div>
					<a class="lostpassword" href="<?php echo wp_lostpassword_url(); ?>"><?php _e("Şifremi Unuttum", "lara") ?></a>
					<input type="hidden" name="sfr_task" value="login">
				</div>
			</div>
			<div class="container">
				<div class="itemContainer">
					<button class="check submit" style="display: inline-block;"><?php _e("Giriş Yap", "lara"); ?></button>
				</div>
			</div>
		</form>
		</div>
	</div>

	<div class="rightSide safirBox">
		<div class="pageHeading">
			<h2 class="title"><?php _e("Kayıt Ol", "lara") ?></h2>
		</div>
		<?php if(get_option("users_can_register")) : ?>
			<div class="sfrIconForm">
				<form method="post" name="sfrRegisterForm">
					<?php
					$securityNumber = rand(100000,999999);
					if(!$result1) {
						$result1 = array('class' => 'status info', 'message' => __('Aşağıdaki formu doldurarak sitemize kayıt olun.', 'lara'));
					}
					?>
					<p class="<?php echo $result1['class'] ?>" data-loading="<?php _e("Lütfen bekleyiniz", "lara") ?>..."><?php echo $result1['message'] ?></p>
					<div class="container">
						<div class="itemContainer">
							<div class="item identity"><div class="icon"><span></span></div>
								<input name="sfr_name" type="text" placeholder="<?php _e("Adınız", "lara") ?> *" value="<?php echo $info['name'] ?>" />
							</div>
						</div>
						<div class="itemContainer">
							<div class="item identity"><div class="icon"><span></span></div>
								<input name="sfr_surname" type="text" placeholder="<?php _e("Soyadınız", "lara") ?> *" value="<?php echo $info['surname'] ?>" />
							</div>
						</div>
						<div class="itemContainer">
							<div class="item name"><div class="icon"><span></span></div>
								<input name="sfr_username" type="text" placeholder="<?php _e("Kullanıcı adınız", "lara") ?> *" value="<?php echo $info['username'] ?>" />
							</div>
						</div>
						<div class="itemContainer">
							<div class="item mail"><div class="icon"><span></span></div>
								<input name="sfr_email" type="text" placeholder="<?php _e("Email adresiniz", "lara") ?> *" value="<?php echo $info['email'] ?>" />
							</div>
						</div>
						<div class="itemContainer">
							<div class="item password"><div class="icon"><span></span></div>
								<input name="sfr_password1" type="password" placeholder="<?php _e("Şifreniz", "lara") ?> *" value="<?php echo $info['password1'] ?>" />
							</div>
						</div>
						<div class="itemContainer">
							<div class="item password"><div class="icon"><span></span></div>
								<input name="sfr_password2" type="password" placeholder="<?php _e("Şifreniz (tekrar)", "lara") ?> *" value="<?php echo $info['password2'] ?>" />
							</div>
						</div>
						<div class="itemContainer">
							<div class="item question"><div class="icon"><span></span></div>
								<input name="sfr_captcha" type="text" placeholder="<?php _e("Güvenlik kodu", "lara") ?> *" value="<?php echo $info['captcha'] ?>" />
								<img class="captchaimg" src="<?php bloginfo('template_url') ?>/lib/captcha/image.php?s=<?php echo $securityNumber ?>" alt="Captcha" width="120" height="34" />
							</div>
						</div>
					</div>
					<button class="check submit"><?php _e("Kaydol", "lara"); ?></button>
					<input type="hidden" name="sfr_md5" value="<?php echo md5($securityNumber) ?>">
					<input type="hidden" name="sfr_task" value="register">
				</form>
			</div>
		<?php else: ?>
			<div class="sfrIconForm">
				<p class="status warning"><?php _e("Üyelik alımı geçici olarak kapalıdır.", "lara"); ?></p>
			</div>
		<?php endif; ?>
	</div>
</div>

</div></div></div>


<?php get_footer(); ?>
