<?php
/*
	Template Name: İçerik Düzenle
*/
?>
<?php
if(!is_user_logged_in()) { wp_redirect(get_page_link(xoption("membershipPage"))); die(); }

$current_user = wp_get_current_user();
$authorID = $current_user->ID;
$result = array();
if($authorID == SAFIR_DEMO_USERID) {
	$result = array('class'=>'status warning', 'message'=> __("Demo kullanıcısı düzenleme yapamaz.", "lara"));
} else {

if(isset($_POST['sfr_task']) && $_POST['sfr_task'] == 'editnews' && isset( $_POST['sfr_editnews_nonce_field'] ) && wp_verify_nonce( $_POST['sfr_editnews_nonce_field'], 'sfr_editnews_nonce' ) ) {

	$result = array();
	$postID = wp_strip_all_tags(sanitize_text_field($_POST['sfr_postID']));
	$title = wp_strip_all_tags(sanitize_text_field($_POST['sfr_title']));
	$category = $_POST['sfr_category'];
	$content = $_POST['sfr_newscontent'];
	$tags = wp_strip_all_tags(sanitize_text_field($_POST['sfr_tags']));

	if($title == '' || $content == '') {
		$result = array('class'=>'status warning', 'message'=>__('Başlık ve içerik alanı zorunludur.','lara'));
	} else {

		$doUpdate = false;

		if( !is_numeric( $postID ) ) $postID = 1;
		if( get_post_field( 'post_author', $postID ) == $authorID ) {

			if(current_user_can('administrator')) {
				$post_status = 'publish';
			} else {
				$post_status = xoption('profilePostEditStatus');
			}
			$postArgs = array(
				'ID'    		=> $postID,
				'post_title'    => $title,
				'post_name'     => $title,
				'post_content'  => $content,
				'post_status'   => $post_status,
				'post_author'   => $authorID,
				'post_category' => $category,
				'tags_input'	=> $tags,
				'comment_status'=> 'open'
			);

			$attachmentIDs = array();
			$uploadCounter = 0;
			foreach( $_FILES as $file ) {
				if( is_array( $file ) && $file['name'] ) {
					$uploadCounter++;
					$allowed =  array('gif','png','jpg','jpeg');
					$filename = $file['name'];
					$filesize = $file['size'];
					$ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
					if( $file['error'] == 0 && in_array($ext, $allowed) && $filesize < SAFIR_MAX_UPLOAD_SIZE ) {
						$attachmentIDs[] = upload_user_file( $file );
					}
				}
			}
			if(count($attachmentIDs) == $uploadCounter) {
				$doUpdate = true;
			} else {
				$doUpdate = false;
				$result = array('class'=>'status warning', 'message'=>__('Bazı resimler yüklenemedi. Lütfen dosya uzantısına ve boyutun en fazla 2 MB olmasına dikkat ediniz.', 'lara'));
				foreach ($attachmentIDs as $attachmentID) {
					wp_delete_attachment($attachmentID, true);
				}
			}

		} else {
			$result = array('class'=>'status warning', 'message'=>__('Hatalı giriş.', 'lara'));
			$doUpdate = false;
		}

		if($doUpdate) {
			$postID = wp_update_post( $postArgs );
			if( is_wp_error($postID) ) {
				$result = array('class'=>'status warning', 'message'=>$postID->get_error_message());
			} else {
				$counter = 0;
				if(count($attachmentIDs) > 0) :
				if($uploadCounter != 0) {
					delete_post_meta($postID, '_thumbnail_id');
					for ($i=1; $i <= 10; $i++) {
						delete_post_meta($postID, 'haberresim' . $i);
					}
				}
				foreach ($attachmentIDs as $attachmentID) {
					$counter++;
					if($counter == 1) {
						add_post_meta($postID, '_thumbnail_id', $attachmentID);
					} else {
						wp_update_post( array(
							'ID' => $attachmentID,
							'post_parent' => $postID
							)
						);
						add_post_meta($postID, 'haberresim' . $counter, $attachmentID);
					}
				}
				endif;

				$message = __('Değişiklikler başarılı bir şekilde kaydedildi.', 'lara');
				if($post_status == 'draft') {
					$message .= ' ' . __('Yönetici onayından sonra yayınlanacaktır.', 'lara');
				} else {
					$message .= ' <a rel="external" href="'. get_permalink($postID). '">' . __("Yazıyı Görüntüle", "lara") . '</a>';
				}
				$result = array('class'=>'status success', 'message'=> $message);

				if(xoption('sendMailtoAdminEdit')) include('sendmailtoadminedit.php');
			}
		}
	}

}


}
?>

<?php get_header() ?>

<?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>

<div class="safirBox">

<div id="profile" class="editnews">

	<div class="pageHeading">
		<h1 class="title"><?php the_title() ?></h1>
		<?php if(xoption('postsPage') != "-1") : ?>
			<div class="profileButtons">
				<a class="list" href="<?php echo get_permalink(xoption('postsPage')) ?>"><?php _e("Eklediklerim", "lara"); ?>
				</a>
			</div>
		<?php endif; ?>
	</div>

	<?php
	$authorID = $current_user->ID;
	$postID = $_GET['post'];
	if(!is_numeric($postID)) $postID = 1;
	$args = array(
		'p' 				=> $postID,
		'author'			=> $authorID,
		'posts_per_page'	=> 1
	);
	$editQuery = new WP_Query($args);
	if( $editQuery->have_posts() && get_post_field( 'post_author', $postID ) == $authorID ) { $editQuery->the_post();
		$title = get_the_title();
		$category = array();
		$postcategory = get_the_category();
		foreach ($postcategory as $cat) {
			$category[] = $cat->term_id;
		}
		$content = get_the_content();
		$tagsArray = get_the_tags();
		if($tagsArray) {
			$tags = '';
			foreach ($tagsArray as $tag) {
				$tags .= $tag->name . ', ';
			}
			$tags = substr($tags, 0, strlen($tags) - 2);
		}
		?>
		<div class="sfrIconForm">
			<form class="editnews" method="post" enctype="multipart/form-data">
				<?php
				if(!$result) {
					if(current_user_can('administrator')) {
						$post_status = 'publish';
					} else {
						$post_status = xoption('profilePostEditStatus');
					}

					$text = "";
					if($post_status == 'draft') {
						$text = '<br/><b>' . __("Dikkat: Düzenleme işlemi sonrası yazının tekrar yayınlanması için site yöneticisinin onayı gerekecektir. Bu süre zarfında yazı yayında olmayacaktır.", "lara") .'</b>';
					}
					$result = array('class' => 'status info', 'message' => __('Yazı ile ilgili değiştirmek istediğiniz bilgileri giriniz. Yeni resim eklediğinizde varsa önceki ekledikleriniz silinecektir. Yüklemezseniz önceki resimler kalacaktır.', 'lara') . $text);
				}
				?>

				<p class="<?php echo $result['class'] ?>" data-loading="<?php _e("Lütfen bekleyiniz", "lara") ?>..."><?php echo $result['message'] ?></p>
				<div class="container">
					<div class="itemContainer">
						<div class="item title">
							<div class="icon"><span></span></div>
							<input name="sfr_title" type="text" placeholder="<?php _e("Yazı Başlığı", "lara"); ?> *" value="<?php echo $title ?>" />
						</div>
					</div>
					<div class="itemContainer">
						<div class="item category">
							<div class="items">
								<?php
								$checkbox_counter = 0;
								if(is_array(xoption('profilePostsCategories'))) :
									foreach (xoption('profilePostsCategories') as $catID) {
										?>
										<div class="checkbox">
											<div class="safirCheckbox">
												<input type="checkbox" name="sfr_category[]" id="sfr_category<?php echo $checkbox_counter?>" value="<?php echo $catID ?>"
													<?php
													if(in_array($catID, $category)) {
														echo " checked";
													}
													?> />
												<label for="sfr_category<?php echo $checkbox_counter?>">
													<span></span><?php echo get_cat_name($catID) ?></label>
											</div>
										</div>
										<?php $checkbox_counter++;
									}
								endif;
								?>
							</div>
						</div>
					</div>
				</div>
				<div class="container half">
					<div class="itemContainer">
						<div class="item image">
							<div class="icon"><span></span></div>
							<label class="fileLabel" for="file.newsImage0"><span class="text"><?php _e("Yazı Kapak Resmi", "lara"); ?></span><span class="button"><?php _e("Resim Seç", "lara"); ?></span></label><input id="file.newsImage0" name="sfr_image0" type="file" accept="image/*" />
						</div>
					</div>
					<div class="itemContainer">
						<div class="item image">
							<div class="icon"><span></span></div>
							<label class="fileLabel" for="file.newsImage1"><span class="text"><?php _e("Yazı Galeri Resmi", "lara"); ?> 1</span><span class="button"><?php _e("Resim Seç", "lara"); ?></span></label><input id="file.newsImage1" name="sfr_image1" type="file" accept="image/*" />
						</div>
					</div>
					<div class="itemContainer">
						<div class="item image">
							<div class="icon"><span></span></div>
							<label class="fileLabel" for="file.newsImage2"><span class="text"><?php _e("Yazı Galeri Resmi", "lara"); ?> 2</span><span class="button"><?php _e("Resim Seç", "lara"); ?></span></label><input id="file.newsImage2" name="sfr_image2" type="file" accept="image/*" />
						</div>
					</div>
					<div class="itemContainer">
						<div class="item image">
							<div class="icon"><span></span></div>
							<label class="fileLabel" for="file.newsImage3"><span class="text"><?php _e("Yazı Galeri Resmi", "lara"); ?> 3</span><span class="button"><?php _e("Resim Seç", "lara"); ?></span></label><input id="file.newsImage3" name="sfr_image3" type="file" accept="image/*" />
						</div>
					</div>
					<div class="itemContainer">
						<div class="item image">
							<div class="icon"><span></span></div>
							<label class="fileLabel" for="file.newsImage4"><span class="text"><?php _e("Yazı Galeri Resmi", "lara"); ?> 4</span><span class="button"><?php _e("Resim Seç", "lara"); ?></span></label><input id="file.newsImage4" name="sfr_image4" type="file" accept="image/*" />
						</div>
					</div>
					<div class="itemContainer">
						<div class="item image">
							<div class="icon"><span></span></div>
							<label class="fileLabel" for="file.newsImage5"><span class="text"><?php _e("Yazı Galeri Resmi", "lara"); ?> 5</span><span class="button"><?php _e("Resim Seç", "lara"); ?></span></label><input id="file.newsImage5" name="sfr_image5" type="file" accept="image/*" />
						</div>
					</div>
				</div>
				<div class="container">
					<div class="itemContainer">
						<div class="item tag">
							<div class="icon"><span></span></div>
							<input name="sfr_tags" type="text" placeholder="<?php _e("Yazıyla ilgili anahtar kelimeler (virgüllerle ayırınız)", "lara"); ?>" value="<?php echo $tags ?>" />
						</div>
					</div>
					<div class="itemContainer">
						<div class="item">
							<?php wp_editor(stripslashes($content), 'sfr_newscontent', array(
								'editor_height' => 220,
								'media_buttons'	=> false,
								'quicktags'		=> false,
								'tinymce' 		=> array('toolbar1'=> 'formatselect bold italic underline bullist numlist link unlink forecolorc image alignleft aligncenter alignright', 'toolbar2'=>''),
							)); ?>
						</div>
					</div>
				</div>
				<input type="hidden" name="sfr_postID" value="<?php echo $postID ?>">
				<input type="hidden" name="sfr_task" value="editnews">
				<button class="check submit"><?php _e("Kaydet", "lara"); ?></button>
				<?php wp_nonce_field( 'sfr_editnews_nonce', 'sfr_editnews_nonce_field' ); ?>
			</form>
		</div>
		<?php
	} else {

		if(isset($_POST['sfr_task']) && $_POST['sfr_task'] == 'editnews' && isset( $_POST['sfr_editnews_nonce_field'] ) && wp_verify_nonce( $_POST['sfr_editnews_nonce_field'], 'sfr_editnews_nonce' ) ) {
			$args = array(
				'p' 				=> $postID,
				'author'			=> $authorID,
				'posts_per_page'	=> 1,
				'post_status'		=> 'draft'
			);
			$editQuery = new WP_Query($args);
			if( $editQuery->have_posts() && get_post_field( 'post_author', $postID ) == $authorID ) {
				_e('Düzenleme işlemi başarılı bir şekilde tamamlandı, yönetici onayından sonra yayınlanacaktır.', 'lara');
			} else {
				_e('Hatalı giriş', 'lara');
			}
		} else {
			_e('Hatalı giriş', 'lara');
		}

	}
	?>
</div>

<?php endwhile; ?>

</div>

</div><!--content-->

<?php
global $activeMenu;
$activeMenu = 'posts';
include( TEMPLATEPATH . '/profile/aside.php');
?>

</div>
<!--main-->
<?php get_footer(); ?>
