<?php
$file_dir = get_bloginfo('template_directory');

function safirpanel_admin_scripts() {
	global $file_dir;
	wp_enqueue_script('media-upload');
	wp_enqueue_script('thickbox');
	wp_enqueue_script('my-upload');
	wp_enqueue_script('minicolors', $file_dir . '/lib/colorpicker/jquery.minicolors.min.js', __FILE__);
	wp_enqueue_script('safirpanel', $file_dir . '/safirpanel/scripts/scripts.js', __FILE__);
}

function safirpanel_admin_styles() {
	global $file_dir;
	wp_enqueue_style('thickbox');
	wp_enqueue_style("minicolors", $file_dir . "/lib/colorpicker/jquery.minicolors.css", false, "0.1", "all");
	wp_enqueue_style("safirpanel", $file_dir . "/safirpanel/css/style.css", false, "0.1", "all");
}

if (isset($_GET['page'])) {
	if($_GET['page'] == 'safirpanel.php') :
		add_action('admin_print_scripts', 'safirpanel_admin_scripts');
		add_action('admin_print_styles', 'safirpanel_admin_styles');
	endif;
}

function add_theme_options_page() {
	global $safirThemeSlug, $sfrOptions;
	if(isset($_GET['page'])) {
		if ( $_GET['page'] == basename(__FILE__) && function_exists('__gc') ) {
			if(isset($_REQUEST['submitted'] )) {
				foreach ($sfrOptions as $option) {
					if(isset($option['id'])) {
						if(isset($_REQUEST[ $safirThemeSlug . "_" . $option['id'] ])) {
							$x = $_REQUEST[ $safirThemeSlug . "_" . $option['id'] ];
							update_option("safir_" . $safirThemeSlug . "_" . $option['id'], $x);
						} else {
							update_option("safir_" . $safirThemeSlug . "_" . $option['id'], "");
						}
					}
				}
			}
		}
	}
	add_menu_page("Safir Panel", "Safir Panel", 'administrator', basename(__FILE__), 'safirpanel_admin');
}

function safirpanel_admin() {
	global $safirThemeSlug, $sfrOptions;
	?>
	<div class="wrap" id="safirpanel">
		<?php
		if(isset($_REQUEST['submitted'])) {
			if ($_REQUEST['submitted'] == "true") {
				safir_delete_cache();
				if(session_id()) session_destroy();
				if (SAFIR_CACHE_ENABLED) {
					echo('<div class="updated settings-error"><p style="font-weight:bold;">Ayarlar başarılı bir şekilde değiştirildi ve Cache bellek başarılı bir şekilde temizlendi.<a href="#">Kapat</a></p></div>');
				} else {
					echo('<div class="updated settings-error"><p style="font-weight:bold;">Ayarlar başarılı bir şekilde değiştirildi!<a href="#">Kapat</a></p></div>');
				}
			}
		}

		?>

		<div id="top">
			<div class="logo">
				<img src="<?php bloginfo('template_url') ?>/safirpanel/images/logo.png" width="180" height="70" />
			</div>
			<div id="heading">
				<div class="arrow"></div>
				<div class="titles">
					<?php
					foreach ($sfrOptions as $value) {
						switch ( $value['type'] ) {
							case "section":
							?>
							<div class="title"><?php echo $value['name']; ?></div>
							<?php
						}
					}
					?>
				</div>
				<a class="help" target="_blank" title="Tema Yardım Dosyası" href="http://safirtema.com/yardim/<?php echo $safirThemeSlug ?>.pdf">YARDIM</a>
			</div>
		</div>
		<div id="#main">
			<div id="left">
				<ul class="safirmenu">
					<?php
					foreach ($sfrOptions as $value) {
						switch ( $value['type'] ) {
							case "section":
							?>
							<li><a href="<?php echo (wp_is_mobile() ? "#right" : "#"); ?>" class="<?php echo $value['class']; ?>"><span class="icon"></span><?php echo $value['name']; ?></a></li>
							<?php
						}
					}
					?>
				</ul>
			</div>

			<div id="right">
				<div id="sections">
					<form method="post" action="">
					<?php
					$counter = 0;
					foreach ($sfrOptions as $value) {
						switch ( $value['type'] ) {
							case "section":
							$counter++;
							?>
							<div class="section" id="section<?php echo $counter; ?>">
								<?php if (isset($value['desc'] )) { ?>
								<p class="desc"><?php echo $value['desc']; ?></p>			<?php }	?>
								<?php break;

								case "close":
								?>
								</div><!--closing group div-->
								<?php break;

								case "heading":
								echo '<h3 class="heading">' . $value['text'] . '</h3>';
								break;


								case "desc":
								echo '<p class="desc">' . $value['text'] . '</p>';
								break;

								case "infoBox":
								echo '<div class="infoBox">' . $value['text'] . '</div>';
								break;


								case "link":
								echo '<p>' . $value['desc'] . '</p>';
								break;


								case "seperator":
								echo '<div class="seperator"></div>';
								break;


								case 'text':
								?>
								<div class="safirpanelItem">
									<div class="desc">
										<div class="title"><?php echo $value['name']; ?></div>
										<div class="info"><?php echo $value['desc']; ?></div>
									</div>
									<div class="formitem">
										<input name="<?php echo $safirThemeSlug . "_" . $value['id']; ?>" id="<?php echo $safirThemeSlug ."_" . $value['id']; ?>" type="<?php echo $value['type']; ?>"
										value='<?php if ($x = get_option("safir_" . $safirThemeSlug . "_" . $value['id'])) {
											echo stripslashes( $x ) ;
										}
										?>'
										/>
									</div>
									<div class="clear"></div>
								</div>
								<?php
								break;


								case 'color':
								?>
								<div class="safirpanelItem color">
									<div class="desc">
										<div class="title"><?php echo $value['name']; ?></div>
										<div class="info"><?php echo $value['desc']; ?></div>
									</div>
									<div class="formitem">
										<input name="<?php echo $safirThemeSlug . "_" . $value['id']; ?>" id="<?php echo $safirThemeSlug ."_" . $value['id']; ?>" class="minicolors minicolors-input" type="text"
										value='<?php if ($x = get_option("safir_" . $safirThemeSlug . "_" . $value['id'])) {
											echo stripslashes( $x ) ;
										}
										?>'
										/>
									</div>
									<div class="clear"></div>
								</div>
								<?php
								break;


								case 'hidden':
									?>
									<input name="<?php echo $safirThemeSlug . "_" . $value['id']; ?>" id="<?php echo $safirThemeSlug ."_" . $value['id']; ?>" type="hidden"
									value='<?php if ($x = get_option("safir_" . $safirThemeSlug . "_" . $value['id'])) {
										echo stripslashes( $x ) ;
									}
									?>'
									/>
									<?php
								break;

								case 'file':
								?>
								<div class="safirpanelItem file">
									<div class="desc">
										<div class="title"><?php echo $value['name']; ?></div>
										<div class="info">
											<?php if (isset($value['desc'])) echo $value['desc']; ?>
										</div>
									</div>
									<div class="formitem">
										<input name="<?php echo $safirThemeSlug . "_" . $value['id']; ?>" id="<?php echo $safirThemeSlug ."_" . $value['id']; ?>" type="text"
										value='<?php if ($x = get_option("safir_" . $safirThemeSlug . "_" . $value['id'])) {
											echo stripslashes( $x ) ;
										}
										?>'
										/>
										<a href="#" class="button mediaButton">Resim Seç</a>
										<img class="uploadImage" src="<?php echo get_option("safir_" . $safirThemeSlug . "_" . $value['id']) ?>" />
									</div>
									<div class="clear"></div>
								</div>
								<?php
								break;


								case 'textarea':
								?>
								<div class="safirpanelItem">
									<div class="desc">
										<div class="title"><?php echo $value['name']; ?></div>
										<div class="info">
											<?php if(isset($value['desc'])) echo $value['desc']; ?></div>
									</div>
									<div class="formitem">
										<textarea name="<?php echo $safirThemeSlug . "_" . $value['id']; ?>" id="<?php echo $value['id']; ?>" ><?php if ($x = get_option("safir_" . $safirThemeSlug . "_" . $value['id'])) {
											echo stripslashes( $x ) ;
										}
										?></textarea>
									</div>
									<div class="clear"></div>
								</div>
								<?php
								break;


								case 'select':
								?>
								<div class="safirpanelItem">
									<div class="desc">
										<div class="title"><?php echo $value['name']; ?></div>
										<div class="info">
											<?php if (isset($value['desc'])) echo $value['desc']; ?>
										</div>
									</div>
									<div class="formitem">
										<select name="<?php echo $safirThemeSlug . "_" . $value['id']; ?>" id="<?php echo $safirThemeSlug . "_" . $value['id']; ?>">
											<?php
											$select_counter = 0;
											foreach ($value['options'] as $option) {  ?>
											<option value="<?php echo $value['values'][$select_counter]; ?>" <?php if ( get_option("safir_".$safirThemeSlug."_" . $value['id']) == $value['values'][$select_counter]) { echo 'selected="selected"'; } ?>><?php echo $option; ?></option>
											<?php $select_counter++; } ?>
										</select>
									</div>
									<div class="clear"></div>
								</div>
								<?php
								break;


								case 'checkbox':
								?>
								<div class="safirpanelItem checkbox">
									<div class="formitem full">
										<div class="checkbox">
											<input type="hidden" name="<?php echo $safirThemeSlug . "_" . $value['id']; ?>" value="0">
											<input type="checkbox" name="<?php echo $safirThemeSlug . "_" . $value['id']; ?>" id="<?php echo $safirThemeSlug . "_" . $value['id']?>" value="1"
											<?php
											if(xoption($value['id'])) echo 'checked';
											?> />
											<label for="<?php echo $safirThemeSlug . "_" .$value['id'] ?>"> <?php echo $value['text'] ?></label>
										</div>
									</div>
									<div class="clear"></div>
								</div>
								<?php
								break;


								case 'checkboxlist':
								?>
								<div class="safirpanelItem checkboxlist">
									<div class="formitem full">
										<h4 class="heading">
											<?php if (isset($value['desc'])) echo $value['desc']; ?>
										</h4>
										<div class="selectButtons"><span class="selectAll">Tümünü Seç</span> - <span class="selectNone">Seçimi Kaldır</span></div>
										<div class="items">
											<?php
											$savedData = xoption($value['id']);
											if(!is_array($savedData)) $savedData = array();
											$checkbox_counter = 0;
											foreach ($value['options'] as $option) {
												?>
												<div class="checkbox item">
													<input type="checkbox" name="<?php echo $safirThemeSlug . "_" . $value['id']; ?>[]" id="<?php echo $safirThemeSlug . "_" . $value['id'] .  $checkbox_counter?>" value="<?php echo $value['values'][$checkbox_counter]?>"
													<?php
													if(in_array($value['values'][$checkbox_counter], $savedData)) {
														echo " checked";
													}
													?> />
													<label style="display:inline; float:none;" for="<?php echo $safirThemeSlug . "_" . $value['id'] .  $checkbox_counter?>"> <?php echo $option?></label>
												</div>
												<?php $checkbox_counter++;
											}
											?>
										</div>
									</div>
								</div>
								<?php
								break;

							}

						}

						?>

						<p class="submit">
							<?php
							if(SAFIR_CACHE_ENABLED) : $text = 'Değişiklikleri Kaydet ve Önbelleği Temizle'; else :  $text = 'Değişiklikleri Kaydet'; endif;
							?>
							<input name="action" type="submit" value="&#10004; <?php echo $text; ?>" />
							<input name="submitted" type="hidden" value="true" />
						</p>
					</form>
				</div>
			</div>
		</div>

	</div>
<?php
}

add_action('admin_menu', 'add_theme_options_page');
?>
