<div id="single">

<div class="safirBox">

	<div class="pageHeading">
		<h1 class="title"><?php the_title(); ?></h1>
		<?php if(xoption('breadcrumb')) : ?>
			<div id="breadcrumb">
				<?php sfrBreadcrumbs(); ?>
			</div>
		<?php endif; ?>
	</div>

	<?php if(has_excerpt()) : ?>
		<div class="reading excerpt"><?php the_excerpt(); ?></div>
	<?php endif; ?>

	<?php get_template_part('parts/metabox'); ?>

	<?php
	$singleBlock = xoption('singleBlock');
	$noThumbCats = xoption('noThumbCats');
	if(is_array($noThumbCats)) :
		foreach(get_the_category() as $category) {
			if(in_array($category->cat_ID, $noThumbCats)) {
				$singleBlock = "type4";
			}
		}
	endif;

	switch ($singleBlock) {
		case 'type1':
			?>
				<div id="singleBlock" class="type1">
					<div class="thumb">
						<div class="safirthumb"><?php safirthumb(); ?></div>
					</div>
					<?php safirAd('singleAd1', 'ads type1'); ?>
				</div>
			<?php
			break;

		case 'type2':
			if(xoption("singleAd2Desktop")) :
				?>
					<div id="singleBlock" class="type2">
						<?php safirAd('singleAd2', 'ads type2'); ?>
						<div class="thumb">
							<div class="safirthumb"><?php safirthumb(); ?></div>
						</div>
					</div>
				<?php
			else:
				?>
					<div id="singleBlock" class="type2 noad">
						<?php safirAd('singleAd2', 'ads type2'); ?>
						<div class="thumb">
							<div class="safirthumb"><?php safirthumb(); ?></div>
						</div>
					</div>
				<?php
			endif;
			break;

		case 'type3':
			?>
				<div id="singleBlock" class="type3">
					<?php safirAd('singleAd2', 'ads type3'); ?>
					<div class="thumb">
						<div class="safirthumb"><?php safirthumb(); ?></div>
					</div>
				</div>
			<?php
			break;

	}
	?>

	<div id="singleContent" class="reading">
		<?php the_content(); ?>
		<?php
		$attachments = '';
		for ($i=1; $i <= 5 ; $i++) {
			if($x = get_post_meta(get_the_ID(), 'haberresim' . $i, true)) {
				$attachments .= $x . ',';
			}
		}
		if($attachments) echo do_shortcode('[gallery ids='.$attachments.']')
		?>
	</div>

	<div id="page-links">
		<?php wp_link_pages(array('link_before'=>'<span>', 'link_after'=>'</span>', 'before'=>'')); ?>
	</div>

	<?php safirAd('singleAd3', 'ads singleAd3'); ?>

	<?php if(xoption("showTags")) :?>
		<?php if(has_tag()) : $tagTitle = __("ETİKETLER", "lara"); ?>
		<div class="tags">
			<?php the_tags('<span class="title">'.$tagTitle.':</span> ',', ',''); ?>
		</div>
		<?php endif; ?>
	<?php endif; ?>

</div>

<?php if(xoption("showAuthorBox")) : ?>
	<div class="mainHeading stick margintop">
		<div class="safiricon icon icon61"></div>
		<div class="title"><?php _e("YAZAR BİLGİSİ", "lara") ?></div>
	</div>
	<div class="safirBox" style="margin:0;">
		<?php
		$authorID = get_the_author_meta('ID');
		$authorName = get_the_author_meta( 'display_name', $authorID );
		$authorMail = get_the_author_meta( 'user_email', $authorID );
		$authorBio = get_the_author_meta( 'user_description', $authorID );
		$authorFacebook = get_the_author_meta( 'facebook', $authorID );
		$authorTwitter = get_the_author_meta( 'twitter', $authorID );
		$authorInstagram = get_the_author_meta( 'instagram', $authorID );
		$authorLinkedin = get_the_author_meta( 'linkedin', $authorID );
		$image = safir_get_author_image($authorID, 150);
		?>
		<div class="authorBox">
			<div class="thumb">
				<div class="image">
					<a href="<?php echo get_author_posts_url($authorID) ?>"><img src="<?php echo $image; ?>" width="140" height="140" alt="<?php echo $authorName ?>" /></a>
				</div>
			</div>
			<div class="detail">
				<div class="title">
					<a href="<?php echo get_author_posts_url($authorID) ?>">
						<?php echo $authorName ?>
					</a>
				</div>
				<div class="bio">
					<?php echo $authorBio ?>
				</div>
				<div class="share safirSocial">
					<ul>
						<?php if($authorFacebook) : ?>
							<li class="facebook">
								<a rel="external" href="<?php echo $authorFacebook ?>"></a>
							</li>
						<?php endif; ?>
						<?php if($authorTwitter) : ?>
							<li class="twitter">
								<a rel="external" href="<?php echo $authorTwitter ?>"></a>
							</li>
						<?php endif; ?>
						<?php if($authorInstagram) : ?>
							<li class="instagram">
								<a rel="external" href="<?php echo $authorInstagram ?>"></a>
							</li>
						<?php endif; ?>
						<?php if($authorLinkedin) : ?>
							<li class="linkedin">
								<a rel="external" href="<?php echo $authorLinkedin ?>"></a>
							</li>
						<?php endif; ?>
					</ul>
				</div>
			</div>
		</div>
	</div>
<?php endif; ?>

<?php
// BENZER YAZILAR:
if(xoption('relatedCount') != 0) :
	include('lib/safirtema/relatedargs.php');
	$query = new wp_query($args);
	if($query->have_posts()) : ?>
			<div id="related" class="margintop">
				<div class="mainHeading stick">
					<div class="safiricon icon icon5"></div>
					<div class="title"><?php _e("BENZER KONULAR", "lara") ?></div>
				</div>
				<div class="safirBox" style="margin:0">
					<?php
					$listing = xoption("listing");
					switch ($listing) {
						case "style1":
						?>
						<div style="margin:0" class="advancedPostsWidget1 homeWidget listing <?php if(xoption("archiveShowSummary")) echo "withSummary"; ?>">
							<div class="items">
								<?php
								while ($query->have_posts()) : $query->the_post();
									get_template_part('posts/post1');
								endwhile;
								?>
							</div>
						</div>
						<?php
						break;

						case "style2" :
						?>
						<div style="margin:0" class="advancedPostsWidget2 homeWidget listing">
							<div class="items">
								<?php
								while ($query->have_posts()) : $query->the_post();
									get_template_part('posts/post2');
								endwhile;
								?>
							</div>
						</div>
						<?php
						break;
					}
					?>
				</div>
			</div>
		<?php
	endif;
endif;
wp_reset_postdata();
?>

<?php comments_template(); ?>

</div><!--single-->
